<?php
require_once('inc/functions.php');
$link = getMyConection();

// Include the main TCPDF library (search for installation path).
require_once('vendor/tcpdf/tcpdf_config.php');
require_once('vendor/tcpdf/tcpdf.php');

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {
    //Page header
    public function Header() {
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set background image
        $img_file = 'assets/img/backgrounds/Membretada-Log.png';
        $this->Image($img_file, 0, 0, 280, 0, '', '', '', true, 100, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }
}

// create new PDF document
$pdf = new MYPDF("L", PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information 
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Logistica LOG');
$pdf->SetTitle('Reporte Fotográfico');
$pdf->SetSubject('Reporte Fotografico');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(12, 26, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);

// remove default footer
$pdf->setPrintFooter(false);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 20);

$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);
$contador = 0;

$consulta = "SELECT sm.idSalida,sm.Origen, sm.Destino,sm.TotalDistanciaRecorrida, sm.FechaSalida, sm.FechaSalidaSeguridad, sm.RutaFotosSalida, sm.FechaRegreso, sm.RutaFotosRegreso, O.Nombre, A.ConfigVehicular FROM salidamercancia sm inner JOIN operadores O ON sm.idOperador=O.idOperador INNER JOIN autotransporte A ON A.idAutotransporte=sm.idAutotransporte  WHERE sm.idSalida=".$_GET["s"];

$resultado = mysqli_query($link, $consulta);


$horizontal = 12;
$vertical = 75;
$w = 40;
$h = 50;
$fitbox = false;
if ($resultado) {
    while ($row = mysqli_fetch_array($resultado)) {
        $contador++;
        //si $contador = 1 imprime encabezado y datos generales
        if ($contador == 1) {
            if ($contador == 1) {
                $pdf->writeHTML('<h2 style="text-align:left;">REPORTE DE UNIDADES DE VIAJE</h2>', true, false, true, false, '');
                $pdf->writeHTML('<p style="font-size:14px;"><b>Origen:</b> ' . $row["Origen"] . ' <br/><b>Operador:</b> ' . $row["Nombre"] . '<br/><b>Destino:</b> ' . $row["Destino"] . ', <b>Fecha de salida: </b>' . $row["FechaSalida"] . '<br/>', true, false, true, false, '');
                $pdf->writeHTML('<p style="font-size:14px;"><b>FOTOS DE UNIDAD<b></p>', true, false, true, false, '');
            }
        }

        //Mostramos las fotos del trincado
        $ruta = $row["RutaFotosRegreso"];

        if (is_dir($ruta)) {
            $archivos = scandir($ruta);
            $archivos = array_diff($archivos, array(".", "..")); // Eliminar elementos correspondientes a directorios
            $cantidadArchivos = count($archivos);
        
            if ($cantidadArchivos > 0) {
                $numColumnas = 5; // Número de columnas por fila
                $contador = 0;
        
                foreach ($archivos as $archivo) {
                    $imagen = $ruta . '/' . $archivo;
        
                    if (is_file($imagen) && getimagesize($imagen)) {
                        $pdf->Cell(38, 45, $pdf->Image($imagen, $pdf->GetX(), $pdf->GetY(), 38, 45), 1, 0, 'C');
        
                        $contador++;
        
                        // Si se alcanza el número de columnas por fila, se agrega un salto de línea
                        if ($contador % $numColumnas == 0) {
                            $pdf->Ln();
                        }
                    }
                }
        
            } else {
                echo "No hay archivos en la ruta.";
            }
        } else {
            echo "La ruta no es válida o no es un directorio.";
        }
    }
}
else {
    die('Error en la consulta: ' . mysqli_error($link));
}

// Close and output PDF document
$pdf->Output('Reporte de Unidades a viaje.pdf', 'I');
closeConection();
$pdf->setDebugMode(true);
//============================================================+
// END OF FILE
//============================================================+

?>
