<?php
require_once('inc/functions.php');
$link = getMyConection();

// Include the main TCPDF library (search for installation path).
require_once('vendor/tcpdf/tcpdf_config.php');
require_once('vendor/tcpdf/tcpdf.php');

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {
    //Page header
    public function Header() {
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }
}

// create new PDF document with page size LETTER
$pdf = new MYPDF("P", PDF_UNIT, "LETTER", true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('LOG');
$pdf->SetTitle('Reporte tarja de rollos');
$pdf->SetSubject('Reporte tarja de rollos');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(40, 10, 40);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);

// remove default footer
$pdf->setPrintFooter(false);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 20);

$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);
$contador = 0;
//Almacen, BL, contenedor, descripcion, peso
//SELECT almacen.idAlmacen, mercanciatransportada.idMercancia, mercanciatransportada.idContenedor, mercanciatransportada.Descripcion, mercanciatransportada.PesoEnKg FROM almacen INNER JOIN mercanciatransportada ON almacen.idAlmacen=1
$consulta = "SELECT sm.idSalida, P.idPackingList, P.Buque, P.Pedimento, P.Invoice, P.BL, E.Nombre Origen, E2.Nombre Destino, E2.Estado, UCASE(ET.Nombre) NomEstado, A.NumeroEconomico, A.PlacaVehicular ,O.Nombre, sm.FechaSalida
FROM salidamercancia sm 
inner JOIN packinglist P ON sm.idBL=P.idPackingList  
INNER JOIN cfdi_empresas E ON sm.Origen=E.idCliente 
INNER JOIN cfdi_empresas E2 ON sm.Destino=E2.idCliente  
INNER JOIN autotransporte A ON sm.idAutotransporte=A.idAutotransporte
INNER JOIN operadores O ON sm.idOperador=O.idOperador
INNER JOIN cfdi4_c_estado ET ON E2.Estado=ET.Clave WHERE sm.idSalida=" . $_GET["s"];

$peso1 = "SELECT s.idSalida, M.PesoEnKg, s.idMercancia, M.Descripcion, s.idContenedor, c.Contenedor
FROM salidadetalleplat1 s
inner JOIN mercanciatransportada M ON s.idMercancia=M.idMercancia
INNER JOIN contenedores c ON s.idContenedor=c.idContenedor WHERE s.idSalida=" . $_GET["s"];

$peso2 = "SELECT s.idSalida, M.PesoEnKg, s.idMercancia, M.Descripcion, s.idContenedor, c.Contenedor
FROM salidadetalleplat2 s
inner JOIN mercanciatransportada M ON s.idMercancia=M.idMercancia
INNER JOIN contenedores c ON s.idContenedor=c.idContenedor WHERE s.idSalida=" . $_GET["s"];

$contenedor2= "SELECT sd.idMercancia, m.idContenedor
FROM salidadetalleplat2 sd 
inner JOIN mercanciatransportada m ON sd.idMercancia=m.idMercancia WHERE sd.idSalida=" . $_GET["s"];


$resultado = mysqli_query($link, $consulta);
$resultadoPeso1 = mysqli_query($link, $peso1);
$resultadoPeso2 = mysqli_query($link, $peso2);
$resultadoContenedor2 = mysqli_query($link, $contenedor2);

if ($resultado && $resultadoPeso1 && $resultadoPeso2) {
    // Almacenar los resultados en arreglos
    $rowsPeso1 = mysqli_fetch_all($resultadoPeso1, MYSQLI_ASSOC);
    $rowsPeso2 = mysqli_fetch_all($resultadoPeso2, MYSQLI_ASSOC);

    while ($row = mysqli_fetch_assoc($resultado)) {
        //$pdf->writeHTML('<h2 style="text-align:center;">TARJA DE ROLLOS ENVASES Y TAPAS MODELO ESPECIAL</h2>', true, false, true, false, '');
        
        $pdf->writeHTML('<table style="width: 100%; font-size: 11px;"><tr>' .
                        '<td style="width: 30%; text-align: right;"><img src="assets/img/backgrounds/log_logo.jpg" width="100"></td>' .
                        '<td style="width: 70%; text-align: left;"><h1 style="text-align:center;">TARJA DE ROLLOS<br>'.$row["Destino"].'<br>'.$row["NomEstado"].'</h1></td>' .
                        '</tr></table>', true, false, true, false, '');



        $pdf->writeHTML('<p style="text-align:center; font-size: 11px;">'. date('d-m-Y') .'</p>', true, false, true, false, '');
        $pdf->writeHTML('<div style="clear: both;"></div>');
        $pdf->writeHTML('<table style="width: 100%; font-size: 11px;">
                    <tr>
                        <td style="width: 25%;"><b>LINEA TRNSP: </b><br/> 
                            <b>ECO: </b><br/> 
                            <b>PLACA: </b><br/> 
                            <b>OPERADOR: </b><br/> 
                        </td>
                        <td style="width: 25%;"><u>LOG</u><br/> 
                            <u>'. $row["NumeroEconomico"].'</u> <br/> 
                            <u>'. $row["PlacaVehicular"].'</u> <br/>  
                            <u>'. $row["Nombre"].'</u> <br/> 
                        </td>
                        <td style="width: 50%; text-align: right;">
                            <b>BL:</b><u> ' . $row["BL"] . '</u> <br/> 
                            <b>BUQUE: </b><u>'.$row["Buque"].'</u><br/> 
                            <b>PEDIMENTO: </b><u>'.$row["Pedimento"].'</u><br/> 
                            <b>INVOICE: </b><u>'.$row["Invoice"].'</u><br/> 
                        </td>
                    </tr>
                    <tr>
                    <td style="width: 25%; text-align: center;">
                        </td>
                        <td style="width: 25%; text-align: center;">
                            <b>___________________</b><br/> 
                            <b>1A PLATAFORMA</b><br/> 
                        </td>
                        <td style="width: 65%; text-align: center;">
                            <b>___________________</b><br/> 
                            <b>2A PLATAFORMA</b><br/> 
                        </td>
                    </tr>
                </table>', true, false, true, false, '');

        
        // Construir la tabla con ambas secciones de Peso 1 y Peso 2
        $tbl ='<table cellspacing="0" cellpadding="0" style="width: 100%; font-size: 10px; border-collapse: collapse;">
                <tr>
                    <td style="width: 10%; vertical-align: top; padding: 0;">&nbsp;</td> <!-- Columna vacía -->
                    <td style="vertical-align: top; padding: 0; width: 45%;">
                        <table cellspacing="0" cellpadding="1" border="1" style="width: 100%;">
                            <tr>
                                <th><b>Rollos</b></th>
                                <th><b>Peso</b></th>
                            </tr>';



        // Agregar filas para la sección de Peso 1
        $totalPeso1 = 0;
        $maxRows = 5;
        foreach ($rowsPeso1 as $i => $rowPeso1) {
            $tbl .= '<tr>';
            $tbl .= '<td>' . $rowPeso1["Descripcion"] . '</td>';
            $tbl .= '<td>' . $rowPeso1["PesoEnKg"] . '</td>';
            $tbl .= '</tr>';
            $totalPeso1 += 1;

            // Agregar filas vacías para completar 5 filas
            if ($i == count($rowsPeso1) - 1) {
                for ($j = $totalPeso1; $j < $maxRows; $j++) {
                    $tbl .= '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
                }
            }
        }

        $tbl .= '</table>';
        $tbl .= '</td>';
        
        $tbl .= '<td style="width: 10%; vertical-align: top; padding: 0;;">&nbsp;</td>';
        
        $tbl .= '<td style="width: 45%; vertical-align: top; padding: 0;">';
        $tbl .= '<table cellspacing="0" cellpadding="1" border="1" style="width: 100%;">';
        $tbl .= '<tr>';
        $tbl .= '<th><b>Rollos</b></th>';
        $tbl .= '<th><b>Peso</b></th>';
        $tbl .= '</tr>';

        // Agregar filas para la sección de Peso 2
        $totalPeso2 = 0;
        foreach ($rowsPeso2 as $i => $rowPeso2) {
            $tbl .= '<tr>';
            $tbl .= '<td>' . $rowPeso2["Descripcion"] . '</td>';
            $tbl .= '<td>' . $rowPeso2["PesoEnKg"] . '</td>';
            $tbl .= '</tr>';
            $totalPeso2 += 1;

            // Agregar filas vacías para completar 5 filas
            if ($i == count($rowsPeso2) - 1) {
                for ($j = $totalPeso2; $j < $maxRows; $j++) {
                    $tbl .= '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
                }
            }
        }

        $tbl .= '</table>';
        $tbl .= '</td></tr></table>';
       
        // Imprimir la tabla en el PDF
        $pdf->writeHTML($tbl, true, false, false, false, '');

        $pdf->writeHTML('<table style="width: 100%; font-size: 11px;"><tr>' .
                        '<td style="width: 50%;"><b>Total:</b><u> ' . $totalPeso1 . ' Rollos</u></td>' .
                        '<td style="width: 50%; text-align: right;"><b>Total:</b> <u>' . $totalPeso2 . ' Rollos</u></td>' .
                        '</tr></table>', true, false, true, false, '');

                        
        $totalGeneral = $totalPeso1 + $totalPeso2;

            // Crear un arreglo para almacenar los contenedores
            $contenedores = array();

            // Agregar los contenedores de rowPeso1 al arreglo
            foreach ($rowsPeso1 as $rowPeso1) {
                if (isset($rowPeso1["Contenedor"])) {
                    $contenedores[] = $rowPeso1["Contenedor"];
                }
            }

            // Agregar los contenedores de rowPeso2 al arreglo
            foreach ($rowsPeso2 as $rowPeso2) {
                if (isset($rowPeso2["Contenedor"])) {
                    $contenedores[] = $rowPeso2["Contenedor"];
                }
            }

            // Eliminar contenedores duplicados
            $contenedores = array_unique($contenedores);

            // Concatenar los contenedores con "/"
            $contenedoresConcatenados = implode(' / ', $contenedores);

            // Agregar la información de los contenedores al PDF
            $pdf->writeHTML('<table style="width: 100%; font-size: 11px;"><tr>' .
                '<td style="width: 50%;"><b>Contenedores:</b> ' . $contenedoresConcatenados . '</td>' .
                '<td style="width: 40%; text-align: right;"><b>Rollos total:</b></td>' .
                '<td style="width: 10%; text-align: right; border: 1px dotted black;">' . $totalGeneral . '</td>' .
                '</tr></table>', true, false, true, false, '');

            $altura_deseada = 100;

            // Crear una tabla con una sola celda y centrarla horizontalmente
            $html = '<table style="width: 520px; height: '.$altura_deseada.'px; margin: 20px auto; border-collapse: collapse; border: 2px solid black;">
                        <tr><td align="center" style="height: '.$altura_deseada.'px;">
                            &nbsp; <!-- Caracter no imprimible para mantener el espacio del td -->
                        </td></tr>
                    </table>';

            $pdf->writeHTML($html, true, false, false, false, '');

            // Agregar el h4 al PDF
            $pdf->writeHTML('<h6 style="text-align: center; margin-top: 10px;">FIRMA Y SELLO DEL CLIENTE / SE RECIBEN ROLLOS INTACTOS</h6>', true, false, false, false, '');
    }
} else {
    die('Error en la consulta: ' . mysqli_error($link));
}

// Close and output PDF document
$pdf->Output('Reporte de Tarjas de rollos.pdf', 'I');
closeConection();
$pdf->setDebugMode(true);
//============================================================+
// END OF FILE
//============================================================+

?>
