<?php
require_once('inc/functions.php');
$link = getMyConection();

// Include the main TCPDF library (search for installation path).
require_once('vendor/tcpdf/tcpdf_config.php');
require_once('vendor/tcpdf/tcpdf.php');

// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF {
    //Page header
    public function Header() {
        // get the current page break margin
        $bMargin = $this->getBreakMargin();
        // get current auto-page-break mode
        $auto_page_break = $this->AutoPageBreak;
        // disable auto-page-break
        $this->SetAutoPageBreak(false, 0);
        // set background image
        $img_file = 'assets/img/backgrounds/Membretada-Log.png';
        $this->Image($img_file, 0, 0, 280, 0, '', '', '', true, 100, '', false, false, 0);
        // restore auto-page-break status
        $this->SetAutoPageBreak($auto_page_break, $bMargin);
        // set the starting point for the page content
        $this->setPageMark();
    }
}

// create new PDF document
$pdf = new MYPDF("L", PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information 
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('LOG');
$pdf->SetTitle('Reporte hoja de viaje');
$pdf->SetSubject('Reporte hoja de viaje');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(12, 26, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(0);
$pdf->SetFooterMargin(0);

// remove default footer
$pdf->setPrintFooter(false);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 20);

$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);
$contador = 0;

$consulta = "SELECT sm.Origen, E.Nombre OrigenNombre, sm.Destino, E2.Nombre DestinoNombre, O.Nombre NombreOperador, A.NumeroEconomico NumeroEconomico ,sm.*
FROM salidamercancia sm
INNER JOIN cfdi_empresas E ON sm.Origen=E.idCliente
INNER JOIN cfdi_empresas E2 ON sm.Destino=E2.idCliente
INNER JOIN operadores O ON sm.idOperador=O.idOperador
INNER JOIN autotransporte A ON sm.idAutotransporte=A.idAutotransporte WHERE sm.idSalida=".$_GET["s"];

$resultado = mysqli_query($link, $consulta);

if ($resultado) {
    while ($row = mysqli_fetch_array($resultado)) {

        $pdf->writeHTML('<h2 style="text-align:center;">HOJA DE VIAJE</h2>', true, false, true, false, '');
        $pdf->writeHTML('<div style="clear: both;"></div>');
        $pdf->writeHTML('<table style="width: 100%; font-size: 14px;"><tr>' .
                        '<td style="width: 50%;">
                        <b>DESTINO: </b>'. mb_convert_encoding($row["DestinoNombre"],'UTF-8','ISO-8859-1') .'<br/> 
                        </td>' .
                        '<td style="width: 50%; text-align: right;">
                        <b>FOLIO CARTA PORTE:</b> _______________ <br/> 
                        </td>' .
                        '</tr></table>', true, false, true, false, '');
        $pdf->writeHTML('<table style="width: 100%; font-size: 14px;">
                        <tr>
                            <td style="width: 25%;"><b>FECHA:</b> ' . $row["FechaSalida"] . '</td>
                            <td style="width: 25%;"><b>UNIDAD:</b> ' . $row["NumeroEconomico"] . '</td>
                            <td style="width: 25%;"><b>KM SALIDA:</b> _______________ </td>
                            <td style="width: 25%;"><b>KM LLEGADA:</b> _______________ </td>
                        </tr>
                    </table>', true, false, true, false, '');
        $pdf->writeHTML('<table style="width: 100%; font-size: 14px;">
                        <tr>
                            <td style="width: 50%;"><b>OPERADOR: </b> ' . mb_convert_encoding($row["NombreOperador"],'UTF-8','ISO-8859-1') . '</td>
                            <td style="width: 25%;"><b>KM RECORRIDO: </b> ' . $row["TotalDistanciaRecorrida"] . ' </td>
                        </tr>
                    </table>', true, false, true, false, '');

        $ltsLlegada = 0;
        $ltsSalida = 0;
        $ltsDestino = 1;
        $rendimiento= ($ltsLlegada - $ltsSalida)/$ltsDestino;
        
        $pdf->writeHTML('<table style="width: 100%; font-size: 14px;">
                    <tr>
                        <td style="width: 25%;"><b>LTS FINAL: </b> _______________ </td>
                        <td style="width: 25%;"><b>LTS DESTINO: </b> _______________</td>
                        <td style="width: 25%;"><b>LTS TOTAL: </b> _______________ </td>
                        <td style="width: 25%;"><b>RENDIMIENTO: </b> '. $rendimiento .'</td>
                    </tr>
                </table>', true, false, true, false, '');            

        $pdf->writeHTML('<table style="width: 100%; font-size: 14px;">
                <tr>
                    <td style="width: 50%;"><b>CASETAS EFECTIVO: </b></td>
                    <td style="width: 50%;"><b> ____________________________ </b></td>
                </tr>
            </table>', true, false, true, false, '');     
            
        $pdf->writeHTML('<table style="width: 100%; font-size: 14px;">
                <tr>
                    <td style="width: 50%;"><b>COMBUSTIBLE EFECTIVO: </b></td>
                    <td style="width: 50%;"><b> ____________________________ </b></td>
                </tr>
            </table>', true, false, true, false, ''); 

        $pdf->writeHTML('<table style="width: 100%; font-size: 14px;">
                <tr>
                    <td style="width: 50%;"><b>REPARACIONES: </b></td>
                    <td style="width: 50%;"><b> ____________________________ </b></td>
                </tr>
            </table>', true, false, true, false, ''); 
    }
}
else {
    die('Error en la consulta: ' . mysqli_error($link));
}

// Close and output PDF document
$pdf->Output('Hoja Viajera '.$_GET["s"].'.pdf', 'I');
closeConection();
$pdf->setDebugMode(true);
//============================================================+
// END OF FILE
//============================================================+

?>
