<?php
require_once('inc/functions.php');
require 'vendor/autoload.php';

// reference the Dompdf namespace
use Spipu\Html2Pdf\Html2Pdf;
use Spipu\Html2Pdf\Exception\Html2PdfException;
use Spipu\Html2Pdf\Exception\ExceptionFormatter;

function redimensionarImagenGD($rutaImagen, $anchoMaximo = 800) {
    // Obtener información de la imagen
    $infoImagen = getimagesize($rutaImagen);
    $ancho = $infoImagen[0];
    $alto = $infoImagen[1];

    // Si el ancho de la imagen es mayor que el ancho máximo permitido
    if ($ancho > $anchoMaximo) {
        // Calcular la nueva altura manteniendo la relación de aspecto
        $proporcion = $alto / $ancho;
        $altoNuevo = $anchoMaximo * $proporcion;

        // Crear una nueva imagen con las nuevas dimensiones
        $imagenRedimensionada = imagecreatetruecolor($anchoMaximo, $altoNuevo);

        // Cargar la imagen original según su tipo MIME
        switch ($infoImagen['mime']) {
            case 'image/jpeg':
                $imagenOriginal = imagecreatefromjpeg($rutaImagen);
                break;
            case 'image/png':
                $imagenOriginal = imagecreatefrompng($rutaImagen);
                break;
            case 'image/gif':
                $imagenOriginal = imagecreatefromgif($rutaImagen);
                break;
            default:
                return $rutaImagen; // Si el formato no es compatible, devuelve la imagen original.
        }

        // Redimensionar la imagen original a la nueva imagen
        imagecopyresampled($imagenRedimensionada, $imagenOriginal, 0, 0, 0, 0, $anchoMaximo, $altoNuevo, $ancho, $alto);

        // Guardar la imagen redimensionada en un archivo temporal
        $rutaTemp = tempnam(sys_get_temp_dir(), 'img_') . '.jpg';
        imagejpeg($imagenRedimensionada, $rutaTemp, 75); // Guardar con calidad de 75 (ajustable)

        // Liberar memoria
        imagedestroy($imagenOriginal);
        imagedestroy($imagenRedimensionada);

        return $rutaTemp; // Devolver la ruta de la imagen redimensionada
    } else {
        // Si la imagen es menor o igual al tamaño máximo, devolver la ruta original
        return $rutaImagen;
    }
}

try {

    $html2pdf = new Html2Pdf('L', 'LETTER', 'en');
    $html2pdf->setDefaultFont('Arial');

    $contenido = '<page backimg="assets/img/backgrounds/Membretada-Log.png" backtop="90px">';

    $consulta = "SELECT UPC.ID, UP.idUnidadPuerto, A.NumeroEconomico AS Transporte, O.Nombre AS Operador, PL.BL, T.Nombre AS Operadora, UP.Cita, UP.Regreso, UPC.idContenedor, C.Contenedor, UP.Status, UP.Observaciones, UPC.Inspeccion, UPC.RutaVacio RutaInspeccion  FROM unidadesapuerto UP INNER JOIN autotransporte A ON UP.idTransporte=A.idAutotransporte INNER JOIN operadores O ON UP.idOperador=O.idOperador INNER JOIN packinglist PL ON UP.idBL=PL.idPackingList INNER JOIN operadoras T ON UP.idOperadora=T.idOperadora INNER JOIN unidadesapuerto_contenedores UPC ON UP.idUnidadPuerto=UPC.idUnidadPuerto INNER JOIN contenedores C ON UPC.idContenedor=C.idContenedor WHERE UPC.ID=".$_GET["s"];
    $resultado = query($consulta);
    
    if ($resultado) {
        while ($row = mysqli_fetch_array($resultado)) {
            $contador++;
            // Si $contador = 1, imprime encabezado y datos generales
            if ($contador == 1) {
                $contenido .= '<h2 style="text-align:left;">REPORTE DE INSPECCION DE CONTENEDOR VACIO</h2>';
                $contenido .= '<p style="font-size:14px;"><b>BL:</b> '. $row["BL"] .'<br/><b>Contenedor:</b> '.$row["Contenedor"].'<br/><b>Transporte:</b> ' . $row["Transporte"] . '<br/><b>Operadora:</b> ' . $row["Operadora"] . ' <br/><b>Cita:</b> ' . $row["Cita"] . ' <br/></p>';
            }
    
            // Mostramos las fotos de los diferentes directorios
            $ruta = $row["RutaInspeccion"];
    
            if (is_dir($ruta)) {
                //$subcarpetas = array("apertura","lado_delantero", "lado_derecho", "lado_izquierdo", "lado_trasero", "sello", "trincado", "otras");
                $numColumnas = 5; // Número de columnas por fila
                $contadorColumnas = 0;

                $archivos = scandir($ruta);
                $archivos = array_diff($archivos, array(".", "..")); // Eliminar elementos correspondientes a directorios

                if (!empty($archivos)) {
                    foreach ($archivos as $archivo) {
                        $imagen = __DIR__ . "/" . $ruta . "/" . $archivo;

                        if (is_file($imagen)) {
                            // Redimensionar la imagen si es necesario
                            $imagenRedimensionada = redimensionarImagenGD($imagen, 800);

                            // Generar el HTML para la imagen redimensionada
                            $imagenHtml = "<img src='" . $imagenRedimensionada . "' width='200'>";
                            $contenido .= $imagenHtml;
                    
                            $contadorColumnas++;
                    
                            // Si se alcanza el número de columnas por fila, se agrega un salto de línea
                            if ($contadorColumnas % $numColumnas == 0) {
                                //$pdf->Ln();
                            }
                        }
                    }
                }
            } else {
                echo "La ruta no es válida o no es un directorio.";
            }
        }
    }

    $contenido .= '</page>';

    $html2pdf->writeHTML($contenido);

    $html2pdf->output('reporte-inspeccion.pdf', 'I');
} catch (Html2PdfException $e) {
    $html2pdf->clean();

    $formatter = new ExceptionFormatter($e);
    echo $formatter->getHtmlMessage();
}
