<?php
require_once("inc/functions.php");
$link = getMyConection();

$page="inspeccion"; 

if(!isset($_GET["s"])) header("Location: inspecciones.php");

$historial = "SELECT UPC.ID, UP.idUnidadPuerto, A.NumeroEconomico AS Transporte, O.Nombre AS Operador, PL.BL, T.Nombre AS Operadora, UP.Cita, UP.Regreso, UPC.idContenedor, C.Contenedor, UP.Status, UP.Observaciones, UPC.Inspeccion, UPC.RutaInspeccion FROM unidadesapuerto UP INNER JOIN autotransporte A ON UP.idTransporte=A.idAutotransporte INNER JOIN operadores O ON UP.idOperador=O.idOperador INNER JOIN packinglist PL ON UP.idBL=PL.idPackingList INNER JOIN operadoras T ON UP.idOperadora=T.idOperadora INNER JOIN unidadesapuerto_contenedores UPC ON UP.idUnidadPuerto=UPC.idUnidadPuerto INNER JOIN contenedores C ON UPC.idContenedor=C.idContenedor WHERE UPC.ID=".$_GET["s"];
$hResult=query($historial);
$RutaInspeccion="";
$postsContent = "";

if($row=mysqli_fetch_array($hResult)){
  $idUnidadPuerto = $row['ID'];
  $idContenedor = $row['idContenedor'];
  $RutaInspeccion = $row['RutaInspeccion'];

  // Nombre del archivo donde se guardan los posts
  $file = $RutaInspeccion . 'posts.txt';

  // Verificar si el archivo existe y tiene contenido
  if (file_exists($file) && filesize($file) > 0) {
      $posts = file_get_contents($file);
      // Convertir los saltos de línea en <br>
      $postsContent = nl2br(htmlspecialchars(trim($posts)));
  }
}

closeConection();
?>
<!DOCTYPE html> 
<html
  lang="es"
  class="light-style layout-menu-fixed"
  dir="ltr"
  data-theme="theme-default"
  data-assets-path="assets/"
  data-template="vertical-menu-template-free"
>
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>
    <title>Inspección de daños - Logistica Omar Gamiño</title>
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/log-truck.svg" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/apex-charts/apex-charts.css" />

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor/js/helpers.js"></script>
    <script src="assets/js/config.js"></script>
    <style>
        textarea {resize: none;}
        .post-content{
            border-radius: 18px;
            background-color: #f0f2f5 !important;
            color:#050505 !important;
        }
    </style>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <?php require_once("inc/menu/aside.php"); ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          <?php require_once("inc/menu/navbar.php"); ?>
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h5 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Inspeccion de daños /</span> <a href="inspecciones.php">Inspección de contenedores</a> /Captura fotogr&aacute;fica</h5>
              <div class="row">
                <div class="col-sm-6">
                  <?php require_once("inc/hInspeccion.php"); ?>
                </div>

                <div class="col-sm-6">
                  <?php require_once("inc/formInspeccion.php"); ?>
                </div>
              </div>

            </div>
            <!-- / Content -->

            <!-- Footer -->
            <?php require_once("inc/footer.php");?>
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script>
      $(document).ready(function() {
          // Obtener el valor de la variable GET 's' de la URL
          var urlParams = new URLSearchParams(window.location.search);
          const idContenedor = urlParams.get('s');
          var ruta = $("#rutaInspeccion").val();
          let originalContent = ''; // Variable global para el contenido original

          if (ruta=="") {
            ruta = 'uploads/inspeccion/' + new Date().getFullYear() + "/" + ('0' + (new Date().getMonth() + 1)).slice(-2) + "/" + ('0' + new Date().getDate()).slice(-2) + "/" + idContenedor + "/";
          } else {
            mostrarImagenes(ruta);
          }

          $('input[type="file"]').on('change', function() {
            // Verificar que idContenedor no sea nulo
            if (idContenedor) {
              // Subir Archivo
              var fileInput = $(this);
              var formData = new FormData();
              var files = fileInput[0].files;
              var archivo = "";
              
              if( fileInput.attr("id")=="cvacio" ){
    
                  // Recorrer los archivos seleccionados y cambiarle el nombre 
                  formData.append("idContenedor", idContenedor);
                  formData.append("cvacio", 1);
                  
                  archivo="scvacio";
                  
                  for (var i = 0; i < files.length; i++) {
                      formData.append(fileInput.attr('name'), files[i]);
                  }
                  formData.append("ruta", ruta + "vacios/");
              }else{
                  archivo = fileInput.attr('name').substring(0, 8);
    
                  formData.append("idContenedor", idContenedor);
                  formData.append("cvacio", 0);
                  
                  // Recorrer los archivos seleccionados y cambiarle el nombre
                  for (var i = 0; i < files.length; i++) {
                      formData.append(fileInput.attr('name'), files[i]);
                  }
                  formData.append("ruta", ruta);
              }
              
              // Agregar barra de progreso al HTML antes de la subida
              $('#s' + archivo).html(`
                <div class="progress">
                    <div id="progressBar${archivo}" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%;"></div>
                </div>
              `);
              
              //Subir las fotos
              $.ajax({
                  url: 'inc/uploadInspeccion.php', // URL donde se enviará el archivo
                  type: 'POST',
                  data: formData,
                  contentType: false,
                  processData: false,
                  beforeSend: function() {console.log('Subiendo archivo(s)...');},
                  xhr: function() {
                    var xhr = new window.XMLHttpRequest();
                    xhr.upload.addEventListener("progress", function(evt) {
                        if (evt.lengthComputable) {
                            var percentComplete = Math.round((evt.loaded / evt.total) * 100);
                            $('#progressBar' + archivo).css('width', percentComplete + '%').text(percentComplete + '%');
                        }
                    }, false);
                    return xhr;
                  },
                  success: function(response) {
                      console.log(response);
                      $('#s' + archivo).html(`<p class="text-success fw-semibold"><i class="bx bx-check-circle fw-semibold"></i> Archivo cargado correctamente. <a href="#" class="removeFile"><i class="bx bx-trash"></i> Eliminar</a></p>`);
                      mostrarImagenes(ruta);
                  },
                  error: function(xhr, status, error) {
                      console.log('Error al subir el archivo');
                  }
              });
            }
          });

          function mostrarImagenes(path) {
              // Limpiar imágenes anteriores
              $('#imagenes').empty();

              $.ajax({
                  url: path,
                  success: function(data) {
                      // Filtrar y mostrar solo imágenes
                      $(data).find("a").each(function() {
                          var fileName = $(this).attr("href");
                          var baseName = fileName.replace(/\.[^/.]+$/, "");

                          if (fileName.match(/\.(jpe?g|png|gif)$/i)) {
                              $('#imagenes').append('<div class="col-4 card p-0 mb-4"><img src="' + path + fileName + '" alt="' + baseName + '" class="card-img-top"></div>');
                              baseName = fileName.substring(0, 8);
                              $('#s' + baseName).html(`<p class="text-success fw-semibold"><i class="bx bx-check-circle fw-semibold"></i> Archivo cargado correctamente. <a href="#" class="removeFile" data-file="` + fileName + `"><i class="bx bx-trash"></i> Eliminar</a></p>`);
                          }
                      });
                  },
                  error: function(xhr, status, error) {
                      console.log('Error al cargar las imágenes: ' + error + '. Ruta: ' +path);
                  }
              });
          }

          // Manejar clic en el enlace de eliminar
          /*$(document).on('click', '.removeFile', function(e) {
              e.preventDefault(); // Prevenir la acción predeterminada del enlace

              var fileName = $(this).data('file');
              var baseName = fileName.substring(0, 8);

              console.log(fileName);

              // Confirmar antes de eliminar
              if (confirm("¿Estás seguro de que deseas eliminar este archivo?")) {
                  // Enviar una solicitud AJAX para eliminar el archivo en el servidor
                  $.ajax({
                      url: 'delete_file.php', // La ruta de tu script para eliminar el archivo
                      method: 'POST',
                      data: { file: fileName },
                      success: function(response) {
                          if (response.success) {
                              // Eliminar el elemento de la interfaz de usuario
                              $('#s' + baseName).remove();
                              // También podrías eliminar la imagen correspondiente si es necesario
                              $('#imagenes img[alt="' + baseName + '"]').closest('.col-4').remove();
                          } else {
                              alert("Error al eliminar el archivo: " + response.message);
                          }
                      },
                      error: function(xhr, status, error) {
                          console.log('Error al eliminar el archivo: ' + error);
                      }
                  });
              }
          });*/

          $('.removeFile').on('click', function(e) {
              e.preventDefault();
              // Lógica para eliminar el archivo en el servidor si es necesario
              // Ejemplo de llamada AJAX para eliminar el archivo:
              console.log(ruta);

              $.ajax({
                  url: 'inc/rmFileInspeccion.php',
                  type: 'POST',
                  data: { ruta: ruta + files[0].name },
                  success: function(response) {
                      // Eliminar el mensaje de éxito y restaurar el input file

                      $('#darchivo1').html(`
                          <label for="archivo1" class="form-label">Foto del sello</label>
                          <input class="form-control" type="file" id="archivo1" name="archivo1" required>
                      `);
                  },
                  error: function(xhr, status, error) {
                      console.error('Error al eliminar el archivo: ' + error);
                  }
              });
          });

          // Función pública para ajustar el número de filas del textarea
          function adjustTextareaRows(textarea) {
              // Verificar si el textarea existe y tiene un valor válido
              if (textarea && textarea.val()) {
                  var lines = textarea.val().split('\n').length;
                  textarea.attr('rows', lines);
              } else {
                  // Si no hay contenido, establecer las filas a 1 o cualquier número que prefieras
                  textarea.attr('rows', 1);
              }
          }

          function attachTextareaEvents(textarea) {
              textarea.on('input', function() {
                  adjustTextareaRows($(this));
              });

              textarea.keydown(function(e) {
                  if (e.which == 13 && !e.shiftKey) { // Enter key without Shift
                      e.preventDefault();
                      savePost($(this));
                  } else if (e.which == 27) { // Escape key
                      cancelEdit($(this));
                  }
              }).focusout(function() {
                  cancelEdit($(this));
              });
          }

          function savePost(textarea) {
              var postContent = textarea.val().trim();
              console.log(ruta + 'posts.txt');
              $.post('inc/inspeccion/save_post.php', { content: postContent, id: idContenedor }, function(data) {
                  if (data.success) {
                      $('#postTextarea').val('');
                      $('#postTextarea').remove();

                      $('#postsContainer').html(`
                          <div class="post">
                              <div class="d-flex align-items-center">
                                  <div class="ml-3 post-content p-3">${data.content.replace(/\n/g, '<br>')}</div>    
                                  <button class="btn btn-light" type="button" data-toggle="dropdown">
                                      <svg viewBox="0 0 16 16" width="16" height="16" fill="currentColor" class="x19dipnz x1lliihq x1tzjh5l x1k90msu x2h7rmj x1qfuztq" style="color: #65676b;"><g fill-rule="evenodd" transform="translate(-448 -544)"><path d="M457.5 552a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m5 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m-10 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0"></path></g></svg>
                                  </button>
                                  <div class="dropdown-menu">
                                      <a class="dropdown-item editPost" href="#">Editar</a>
                                      <a class="dropdown-item deletePost" href="#">Eliminar</a>
                                  </div>
                              </div>
                          </div>
                      `);
                  }
              }, 'json');
          }

          function cancelEdit(textarea) {
              if (originalContent && originalContent.trim() !== '') {
                  // Si hay contenido original, restaurarlo
                  textarea.replaceWith(`<div class="ml-3 post-content p-3">${originalContent.replace(/\n/g, '<br>')}</div>`);
              } else {
                  // Si no hay contenido original, agregar un nuevo textarea
                  textarea.replaceWith(`
                      <textarea id="postTextarea" class="form-control" rows="3" placeholder="Write your post here..."></textarea>
                  `);
                  var newTextarea = $('#postTextarea');
                  adjustTextareaRows(newTextarea);
                  attachTextareaEvents(newTextarea);
              }
          }

          // Inicialmente se adjuntan eventos al textarea principal
          attachTextareaEvents($('#postTextarea'));

          // Delete post
          $(document).on('click', '.deletePost', function() {
              let post = $(this).closest('.post');
              post.remove();
              $.post('inc/inspeccion/delete_post.php?id='+idContenedor, function(data) {
                console.log(data);
              }); // Simple call to delete the content in the file

              // Reiniciar el textarea para escribir contenido
              $('#postsContainer').prepend(`
                  <textarea id="postTextarea" class="form-control" rows="3" placeholder="Escribe tus observaciones aquí..."></textarea>
              `);

              var newTextarea = $('#postTextarea');
              adjustTextareaRows(newTextarea);
              attachTextareaEvents(newTextarea);
          });
          
          // Edit post
          $(document).on('click', '.editPost', function() {
              var post = $(this).closest('.post');
              var contentDiv = post.find('.post-content');

              // Leer contenido directamente del archivo
              $.get('inc/inspeccion/read_post.php?id=' + idContenedor, function(data) {
                  if (data.success) {
                      originalContent = data.content.trim(); // Guardar el contenido original desde el archivo

                      // Reemplazar saltos de línea en el textarea
                      var textareaContent = originalContent.replace(/\n/g, "\n").trim();

                      // Contar el número de líneas para ajustar el número de filas en el textarea
                      var lineCount = (textareaContent.match(/\n/g) || []).length + 1;

                      // Reemplazar el div con el textarea
                      contentDiv.replaceWith(`<textarea class="form-control editTextarea" rows="${lineCount}">${textareaContent}</textarea>`);
                      var textarea = $('.editTextarea');
                      textarea.focus();

                      // Adjuntar eventos al textarea de edición
                      attachTextareaEvents(textarea);
                  }
              }, 'json');
          });
      });
    </script>
  </body>
</html>