<?php
// Cargar PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require 'vendor/autoload.php'; // Ajusta la ruta según tu estructura de archivos
require 'inc/functions.php';

// Consulta SQL para obtener los contenedores pendientes de entrega
$sql = "SELECT 
            PL.idPackingList,
            PL.BL,
            PL.EntregaVacios,
            C.idContenedor,
            C.Contenedor,
            DATEDIFF(PL.EntregaVacios, CURDATE()) AS DiasRestantes,
            V.FechaCita
        FROM packinglist PL
        INNER JOIN contenedores C ON PL.idPackingList = C.idPL
        LEFT JOIN vaciosdetalles VD ON VD.idContenedor = C.idContenedor
        LEFT JOIN vacios V ON V.idVacio = VD.idVacio
        WHERE (V.FechaCita IS NULL)
          AND DATEDIFF(PL.EntregaVacios, CURDATE()) >= 0
        ORDER BY DiasRestantes";

$result = query($sql);

// Iniciar la tabla HTML
$htmlContent = '<h1>Reporte de Contenedores Próximos a Vencer</h1>
<table border="1" cellspacing="0" cellpadding="5">
    <thead>
        <tr>
            <th>ID BL</th>
            <th>BL</th>
            <th>Contenedor</th>
            <th>Fecha Entrega Vacíos</th>
            <th>Días Restantes</th>
            <th>Fecha Cita</th>
        </tr>
    </thead>
    <tbody>';

// Verificar si hay resultados
if ($result->num_rows > 0) {
    // Recorrer los resultados y crear las filas de la tabla
    while ($row = $result->fetch_assoc()) {
        $diasRestantes = $row['DiasRestantes'];
        
        // Asignar clase según los días restantes
        $class = '';
        if ($diasRestantes == 0) {
            $class = 'style="background-color: #f8d7da; color: #721c24;"'; // Rojo claro
        } elseif ($diasRestantes == 1 || $diasRestantes == 2) {
            $class = 'style="background-color: #fff3cd; color: #856404;"'; // Naranja claro
        }

        $htmlContent .= '<tr ' . $class . '>
                <td>' . $row['idPackingList'] . '</td>
                <td>' . $row['BL'] . '</td>
                <td>' . $row['Contenedor'] . '</td>
                <td>' . $row['EntregaVacios'] . '</td>
                <td>' . $diasRestantes . '</td>
                <td>' . ($row['FechaCita'] ? $row['FechaCita'] : '') . '</td>
              </tr>';
    }
} else {
    $htmlContent .= '<tr><td colspan="7">No hay contenedores próximos a vencer.</td></tr>';
}

$htmlContent .= '</tbody></table>';

// Configurar PHPMailer
$mail = new PHPMailer(true);

try {
    // Configuración del servidor SMTP
    $mail->isSMTP();
    $mail->SMTPDebug = SMTP::DEBUG_SERVER;
    $mail->Host = 'mail.logisto.com.mx';  // Especifica tu servidor SMTP
    $mail->Port = 587;  // Puerto TCP para SMTPS (SSL/TLS)
    $mail->SMTPAuth = true;
    $mail->Username = 'no-reply@logisto.com.mx';  // Tu dirección de correo electrónico
    $mail->Password = 'hACxRX3Uz6LI';  // Tu contraseña de correo electrónico

    // Configuración del correo
    $mail->setFrom('no-reply@logmzo.com.mx', mb_convert_encoding('Logistica Omar Gamiño','ISO-8859-1','UTF-8'));
    $mail->addReplyTo('no-reply@logisto.com.mx');
    
    $mail->addAddress('operaciones1@logmzo.com.mx');
    $mail->addAddress('vacios@logmzo.com.mx');
    $mail->addBCC('alecks1@gmail.com');
    
    
    $mail->isHTML(true);  // Configurar el formato de correo como HTML
    $mail->Subject = mb_convert_encoding('Reporte de Contenedores Próximos a Vencer','ISO-8859-1','UTF-8');
    $mail->Body    = $htmlContent;

    // Enviar correo
    $mail->send();
    echo 'El reporte ha sido enviado con éxito.';
} catch (Exception $e) {
    echo "Error al enviar el correo: {$mail->ErrorInfo}";
}
